/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: HostStateDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    Host State Get/Set Test dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-04-29  Updated to latest cifXUser / stdint.h
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file HostStateDlg.h
///   Host State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Host State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CHostStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CHostStateDlg)

public:
	CHostStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CHostStateDlg();

// Dialog Data
	enum { IDD = IDD_HOSTSTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t    m_ulSetTimeout;   //!< Timeout when calling Set Host State
  CComboBox   m_cNewStateCtrl;  //!< Set Host State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
